@extends('layouts.vendor')

@section('content')

<style>
    .bg-purple{
        background-color : purple !important;
    }
    .cs-pagination span svg {
        width: 10px;
        height: 10px;
    }
    .bg-pink{
        background-color : #e83e8c !important;
    }
    .bg-darkGreen{
        background-color :rgb(4, 100, 1)
    }
</style>
<div class="col-9 main-dash-left">
    <div class="notification-block">
        <div class="d-flex justify-content-between align-items-center mb-3 noti-inner">
            <h4 class="mb-0">All Notifications</h4>
            @if($notifications->where('is_read', false)->count() > 0)
                <form action="{{ route('vendor.notifications.read.all') }}" method="POST">
                    @csrf
                    <button type="submit" class="noti-btn">
                        <i class="fas fa-check-circle me-1"></i> Mark All as Read
                    </button>
                </form>
            @endif
        </div>

        @if($notifications->isEmpty())
            <p class="text-muted">No notifications found.</p>
        @else
        <div class="mb-3 d-flex justify-content-between align-items-center">
            <div class="d-flex w-100">
                <input type="text" id="searchNotifications" 
                    class="form-control form-control-lg me-3 flex-grow-1"
                    placeholder="Search notifications...">
        
                <form method="GET" action="{{ route('vendor.notifications.page') }}" class="flex-shrink-0" style="min-width: 250px;">
                    <select name="type" class="form-select form-select-lg" onchange="this.form.submit()">
                        <option value="">Filter</option>
                        @foreach($types as $type)
                        @php
                            $displayType = str_replace('_', ' ', $type);
                            $displayType = \Illuminate\Support\Str::title($displayType);
                            // After title-casing, make sure 'Spo' becomes 'SPO'
                            $displayType = preg_replace('/\bSpo\b/', 'SPO', $displayType);
                        @endphp
                        <option value="{{ $type }}" {{ request('type') == $type ? 'selected' : '' }}>
                            {{ $displayType }}
                        </option>
                    @endforeach
                    </select>
                </form>
            </div>
        </div>
        
        <!-- Add a no results message element -->
        <div id="noResults" class="alert alert-info d-none">
            No notifications match your search.
        </div>
        
            <ul class="list-group" id="notificationList">
                @foreach($notifications as $notification)
                    <li class="list-group-item d-flex notification-item justify-content-between align-items-start {{ $notification->is_read ? '' : 'fw-bold bg-light' }}">
                    
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center bk-title">
                                @php
                                    switch ($notification->type) {
                                        case 'new_query':
                                            $badgeClass = 'bg-info'; 
                                            break;
                                        case 'booking_cancellation':
                                            $badgeClass = 'bg-danger'; 
                                            break;
                                        case 'max_voucher_limit_exceed':
                                            $badgeClass = 'bg-warning text-dark'; 
                                            break;
                                        case 'Preferred Timings':
                                            $badgeClass = 'bg-primary';
                                            break;
                                        case 'spo_product_request':
                                            $badgeClass = 'bg-warning'; 
                                            break;
                                        case 'payment_link_paid':
                                            $badgeClass = 'bg-dark';
                                            break;
                                        case 'new_booking_request':
                                            $badgeClass = 'bg-purple bg-secondary';
                                            break;
                                        case 'new_SPO_registration':
                                            $badgeClass = 'bg-success';
                                            break;
                                        case 'user_slot_change_request':
                                            $badgeClass = 'bg-pink';
                                            break;
                                        case 'SPO_product_enable':
                                            $badgeClass = 'bg-darkGreen';
                                            break;
                                        default:
                                            $badgeClass = 'bg-secondary';
                                    }

                                    $formattedType = \Illuminate\Support\Str::title(str_replace('_', ' ', $notification->type));
                                @endphp

                                <div>
                                    <span class="badge {{ $badgeClass }} me-2 text-uppercase">
                                        {{ ucwords($formattedType) }}
                                    </span>
                                    {{ ucwords($notification->title) }}
                                </div>
                                @if(!$notification->is_read)
                                <form method="POST" action="{{ route('vendor.notifications.read', $notification->id) }}">
                                    @csrf
                                    <button class="btn btn-sm btn-outline-success" title="Mark as Read">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                @else
                                    <form method="POST" action="{{ route('vendor.notifications.unread', $notification->id) }}">
                                        @csrf
                                        <button class="btn btn-sm btn-outline-warning" title="Mark as Unread">
                                            <i class="fas fa-flag"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>

                            <p class="description">
                                {{ ucwords($notification->customer_name) }} - {{ $notification->customer_email }} - {{ $notification->customer_phone }}
                            </p>
                            @if($notification->type == 'new_booking_request' || $notification->type == 'new_spo_registration' || $notification->type == 'new_SPO_registration' || $notification->type == 'user_slot_change_request')
                                @if(is_array($notification->data))
                                <ul class="bk-details">
                                        @foreach($notification->data as $item)
                                            <li><strong>{{ ucwords($item['label']) }}:</strong> {{ ucwords($item['value']) }}</li>
                                        @endforeach
                                    </ul>
                                @endif


                            @else
                            @if(is_array($notification->data))
                                <ul class="bk-details">
                                    @foreach($notification->data as $key => $value)
                                        <li><strong>{{ ucwords(str_replace('_', ' ', $key)) }}:</strong> {{ ucwords($value) }}</li>
                                    @endforeach
                                </ul>
                            @else
                                <div class="small text-muted mt-2">{{ $notification->data }}</div>
                            @endif
                            @endif
                        </div>
                        <small class="time">{{ $notification->created_at->diffForHumans() }}</small>
                    </li>
                @endforeach
            </ul>

            <div class="mt-4 cs-pagination">
                {{ $notifications->links() }}
            </div>
        @endif
    </div>
</div>

<script>
    $(document).ready(function(){
        $('#searchNotifications').on('keyup', function(){
            let searchText = $(this).val().toLowerCase().trim();
            let hasResults = false;
            
            // Reset all notifications to visible if search is empty
            if (searchText === '') {
                $('#notificationList .notification-item').show();
                $('#notificationList .notification-item').addClass('d-flex');
                $('#noResults').addClass('d-none');
                return;
            }
            
            $('#notificationList .notification-item').each(function(){
                let notificationText = $(this).text().toLowerCase();
                
                if (notificationText.includes(searchText)) {
                    $(this).addClass('d-flex');
                    $(this).show();
                    hasResults = true;
                } else {
                    console.log(this)
                    $(this).removeClass('d-flex');
                    $(this).hide();
                }
            });

           
            
            // Show/hide no results message
            if (hasResults) {
                $('#noResults').addClass('d-none');
            } else {
                $('#noResults').removeClass('d-none');
            }
        });

        
    });
</script>
@endsection